#ifndef __I_FILE_STREAM_H__
#define __I_FILE_STREAM_H__

#include "IDataStream.h"

/****** IFileStream ***********************************************************
 *	
 *	IFileStream is a specialized IDataStream designed for use with a file. It
 *	supports all the methods of the base IDataStream class. It also handles
 *	simple file creation, but you can also attach a fref if the file is already
 *	open. This stream type will automatically resize the file as needed, so no
 *	pre-allocation is needed.
 *	
 *****  2001 Ian Patterson **************************************************/

class IFileStream : public IDataStream
{
	public:
						IFileStream();
						~IFileStream();
		
		void			OpenFile(FSSpec * theFile);
		void			AttachFile(short inFref)	{ fref = inFref; GetFileInfo(); }
		void			CreateFile(FSSpec * theFile, OSType creator, OSType type);
		
		void			CloseFile(void);
		
		UInt32			GetLength(void)		{ return length; }
		UInt32			GetRemaining(void)	{ return bytesLeft; }
		
		UInt8			HitEOF(void)	{ return (bytesLeft <= 0); }
		
		UInt32			GetPosition(void);
		void			SetPosition(UInt32 position);
		void			Skip(UInt32 numToSkip);
		
		void			ReadBuffer(UInt8 * buf, UInt32 length);
		
		void			WriteBuffer(UInt8 * buf, UInt32 length);
		
		UInt8			DoesAutoResize(void) { return 1; }
	
	private:
		void			GetFileInfo(void);
		
		SInt32	length, bytesLeft;
		
		short	fref;
};

#endif /* __I_FILE_STREAM_H__ */